///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _TABCLIENTDBS_H
#define _TABCLIENTDBS_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"
#include "../Source/SQLImport.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabClientDBSDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND hSQLServer;
    static HWND hSQLDriver;
    static HWND hSQLUserName;
    static HWND hSQLPassword;
    static HWND hTempDir;

    if(uMsg == WM_INITDIALOG)
    {
        hSQLServer   = GetDlgItem(hWnd, IDC_SQLSERVER);
        hSQLDriver   = GetDlgItem(hWnd, IDC_SQLDRIVER);
        hSQLUserName = GetDlgItem(hWnd, IDC_SQLUSERNAME);
        hSQLPassword = GetDlgItem(hWnd, IDC_SQLPASSWORD);
        hTempDir     = GetDlgItem(hWnd, IDC_TEMPDIR);

        Set_Text(hSQLServer, gsSQLCustServer);
        Set_Text(hSQLDriver, gsSQLCustDriver);
        Set_Text(hSQLUserName, gsSQLCustUserID);
        Set_Text(hSQLPassword, gsSQLCustPassword);
        Set_Text(hTempDir, gsImportTempDir);

        return TRUE;
    }

	if(uMsg == WM_COMMAND)
    {
		if(wParam == IDC_PREPARE)
		{
			return FALSE;
		}
	}
	
	if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;

		if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {

			char sSQLCustServer[sizeof(gsSQLCustServer)];
			char sSQLCustDriver[sizeof(gsSQLCustDriver)];
			char sSQLCustUserID[sizeof(gsSQLCustUserID)];
			char sSQLCustPassword[sizeof(gsSQLCustPassword)];
			char sImportTempDir[sizeof(gsImportTempDir)];

			Get_TextEx(hSQLServer, sSQLCustServer, sizeof(sSQLCustServer));
			Get_TextEx(hSQLDriver, sSQLCustDriver, sizeof(sSQLCustDriver));
			Get_TextEx(hSQLUserName, sSQLCustUserID, sizeof(sSQLCustUserID));
			Get_TextEx(hSQLPassword, sSQLCustPassword, sizeof(sSQLCustPassword));
			Get_TextEx(hTempDir, sImportTempDir, sizeof(sImportTempDir));

			strcpy_s(gsSQLCustServer, sizeof(gsSQLCustServer), sSQLCustServer);
			strcpy_s(gsSQLCustDriver, sizeof(gsSQLCustDriver), sSQLCustDriver);
			strcpy_s(gsSQLCustUserID, sizeof(gsSQLCustUserID), sSQLCustUserID);
			strcpy_s(gsSQLCustPassword, sizeof(gsSQLCustPassword), sSQLCustPassword);
			strcpy_s(gsImportTempDir, sizeof(gsImportTempDir), sImportTempDir);
				
			return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
